package com.xebialabs.xlplatform.utils;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicReference;


public class SecureRandomHolder {

    private static final AtomicReference<SecureRandom> holder = new AtomicReference<>();

    public static void init() {
        holder.set(new SecureRandom());
    }

    public static SecureRandom get() {
        SecureRandom secureRandom = holder.get();
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
            if (!holder.compareAndSet(null, secureRandom)) {
                // another thread has initialized the reference
                secureRandom = holder.get();
            }
        }
        return secureRandom;
    }

    public static void nextBytes(byte[] bytes) {
        get().nextBytes(bytes);
    }

    public static byte[] getRandomByteArray(int length) {
        byte[] result = new byte[length];
        nextBytes(result);
        return result;
    }
}
