package com.xebialabs.xlplatform.utils

object ClassLoaderUtils {

  @throws[ClassNotFoundException] def classByName(name: String) = name.loadClass

  implicit class ClassByName(val name: String) extends AnyVal {
    def loadClass = Class.forName(name, true, classLoader)
  }

  implicit def classLoader: ClassLoader = Option(Thread.currentThread().getContextClassLoader).getOrElse(getClass.getClassLoader)
}
