package com.xebialabs.xlplatform.sugar

import java.io.File
import java.nio.file.{Files, Path}

import com.xebialabs.xlplatform.sugar.PathSugar._

trait TempDirectorySugar {

  type DoWithPath[T] = Path => T

  def createTempDirectory(): File = Files.createTempDirectory(this.getClass.getName).toFile

  def withTempDirectory[T](function: DoWithPath[T]): T = {
    val tmpDirectory = createTempDirectory().toPath
    try {
      function(tmpDirectory)
    } finally {
      tmpDirectory.deleteRecursively()
    }
  }

}
