package com.xebialabs.xlplatform.settings

import java.util
import java.util.concurrent.TimeUnit

import com.typesafe.config.Config

import scala.concurrent.duration.FiniteDuration

trait SettingsSupport {

  type ValueExtractor[T] = (String) => T
  val config: Config

  implicit val stringExtractor: ValueExtractor[String] = config.getString
  implicit val intExtractor: ValueExtractor[Int] = config.getInt
  implicit val jListExtractor: ValueExtractor[util.List[String]] = config.getStringList
  implicit val booleanExtractor: ValueExtractor[Boolean] = config.getBoolean
  implicit val durationExtractor: ValueExtractor[FiniteDuration] = (path: String) => FiniteDuration(config.getDuration(path, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS)
  implicit val $conforms: ValueExtractor[SettingsSupport] = null // to shade Predef.conforms implicit

  def value[T](path: String)(implicit extractor: ValueExtractor[T]): T = extractor.apply(path)

  def valueOption[T](path: String)(implicit extractor: ValueExtractor[T]): Option[T] = if (config.hasPath(path)) Option(value(path)(extractor)) else None

  def valueWithDefault[T](path: String, default: T)(implicit extractor: ValueExtractor[T]): T = valueOption(path)(extractor).getOrElse(default)
}