package com.xebialabs.xlplatform.settings

import java.util

import com.typesafe.config.Config

class SecuritySettings(val config: Config) extends SettingsSupport {

  import scala.collection.JavaConverters._

  lazy val enabled: Boolean = valueWithDefault[Boolean]("enabled", false)

  lazy val enabledAlgorithms: Seq[String] = value[util.List[String]]("enabled-algorithms").asScala

  lazy val trustStore: String = value[String]("trust-store")
  lazy val trustStorePassword: String = value[String]("trust-store-password")

  lazy val keyStore: Option[String] = valueOption[String]("key-store")
  lazy val keyPassword: String = value[String]("key-password")
  lazy val keyStorePassword: String = value[String]("key-store-password")

  lazy val protocol: String = value[String]("protocol")
}

