package com.xebialabs.xlplatform.utils

import java.lang.annotation.Annotation

object ReflectionUtils {

  def isAnnotatedWith(item: AnyRef, annotationClass: Class[_ <: Annotation]): Boolean = {
    def getAllClasses(clazz: Class[_]): Seq[Class[_]] = {
      if (clazz == null)
        Nil
      else
        clazz +: (clazz.getInterfaces.flatMap(getAllClasses) ++ getAllClasses(clazz.getSuperclass))
    }
    getAllClasses(item.getClass).exists{_.getAnnotation(annotationClass) != null}
  }

}
