package com.xebialabs.xlplatform.sugar

import scalax.file.Path
import scalax.file.defaultfs.DefaultPath

trait TempDirectorySugar {

  type DoWithPath[T] = DefaultPath => T

  def createTempDirectory() = Path.createTempDirectory(prefix = this.getClass.getName)

  def withTempDirectory[T](function: DoWithPath[T]) {
    val tmpDirectory = createTempDirectory()
    try {
      function(tmpDirectory)
    } finally {
      tmpDirectory.deleteRecursively()
    }
  }

  implicit class PathUtils(path: Path) {
    def toNioPath = path.fileOption.map(_.toPath).get
  }
}
