package com.xebialabs.xlplatform.settings

import java.util.concurrent.TimeUnit

import akka.actor._
import akka.util.Timeout
import com.typesafe.config.Config

import scala.concurrent.duration._


class XlPlatformSettings(config: Config) extends Extension {
  object FileWatch {
    lazy val interval = config.getDuration("xl.file-watch.interval", TimeUnit.MILLISECONDS).millis
    lazy val pollingEnabled = config.hasPath("xl.file-watch.interval") && interval.toMillis > 0
  }

  object ServerExtension {
    private[this] val serverConfig = config.getConfig("xl.server-extension")
    val file = serverConfig.getString("file")
    val timeout = Timeout(serverConfig.getDuration("timeout", TimeUnit.SECONDS), TimeUnit.SECONDS)
    val rootPath = serverConfig.getString("rootPath")
    val scriptsPathPrefix = serverConfig.getString("scriptsPathPrefix")
  }
}

object XlPlatformSettings extends ExtensionId[XlPlatformSettings] with ExtensionIdProvider {
  override def lookup() = XlPlatformSettings

  override def createExtension(system: ExtendedActorSystem) = new XlPlatformSettings(system.settings.config)

  def apply(implicit context: ActorContext): XlPlatformSettings = apply(context.system)
}
