package com.xebialabs.xlplatform.utils

import java.net.URL
import scala.xml.{XML, Elem}

object ResourceUtils {

  def findResources(filePattern: String): Seq[URL] = {
    import collection.convert.wrapAll._
    Thread.currentThread().getContextClassLoader.getResources(filePattern).toSeq
  }

  def loadXmlResources(filePattern: String): Map[URL, Elem] = {
    import ResourceManagement._

    val storeResource = (acc: Map[URL, Elem], next: URL) => {
      map(next.openStream()) { s => acc + (next -> XML.load(s))}
    }
    findResources(filePattern).foldLeft(Map[URL, Elem]())(storeResource)
  }

  def getResourcePath(res: String): Option[String] = {
    Option(Thread.currentThread.getContextClassLoader.getResource(res)).map(_.toURI.getPath)
  }

  def getClassResourcePath(c: Class[_], res: String): Option[String] = {
    Option(c.getResource(res)).map(_.toURI.getPath)
  }

}
