package com.xebialabs.xlplatform.utils

import java.net.URL
import scala.xml.{XML, Elem}

object ResourceUtils {

  def findResources(filePattern: String): Seq[URL] = {
    import collection.convert.wrapAll._
    Thread.currentThread().getContextClassLoader.getResources(filePattern).toSeq
  }

  def loadXmlResources(filePattern: String): List[Elem] = {
    import ResourceManagement._
    findResources(filePattern).map {r =>
        map(r.openStream()) { s =>
          XML.load(s)
        }
    }.toList
  }

}
