package com.xebialabs.xlplatform.utils

import java.lang.annotation.Annotation

object ReflectionUtils {

  def isAnnotatedWith(item: AnyRef, annotationClass: Class[_ <: Annotation]): Boolean = {
    def getAllClasses(clazz: Class[_]): Seq[Class[_]] = {
      if (clazz == null)
        Nil
      else
        clazz +: (clazz.getInterfaces.flatMap(getAllClasses) ++ getAllClasses(clazz.getSuperclass))
    }
    getAllClasses(item.getClass).exists{_.getAnnotation(annotationClass) != null}
  }

  @throws[ClassNotFoundException] def classByName(name: String) = name.loadClass

  implicit class ClassByName(val name: String) extends AnyVal {
    def loadClass = Class.forName(name, true, classLoader)
  }

  implicit def classLoader: ClassLoader = Option(Thread.currentThread().getContextClassLoader).getOrElse(getClass.getClassLoader)
}
