package com.xebialabs.xlplatform.sugar

import com.xebialabs.xlplatform.utils.ReflectionUtils.classLoader

import scala.collection.convert.wrapAsScala._

trait ResourcesSugar {

  def resource(fileResource: String) = Option(classLoader.getResource(fileResource)).getOrElse(notFound(fileResource))

  def resources(fileResource: String) = classLoader.getResources(fileResource).toIterable

  def resourceAsInputStream(fileResource:String) = Option(classLoader.getResourceAsStream(fileResource)).getOrElse(notFound(fileResource))

  private def notFound(classpathResource: String) = throw new IllegalArgumentException(s"Classpath resource $classpathResource not found")
}
