package com.xebialabs.xlplatform.settings

import java.util.concurrent.TimeUnit

import akka.actor._
import akka.util.Timeout
import com.typesafe.config.Config

import scala.concurrent.duration._


class XlPlatformSettings(config: Config) extends Extension {
  object FileWatch {
    lazy val interval = config.getDuration("xl.file-watch.interval", TimeUnit.MILLISECONDS).millis
    lazy val pollingEnabled = config.hasPath("xl.file-watch.interval") && interval.toMillis > 0
  }

  object XlDeploy {
    object ServerExtension {
      val file = config.getString("xl-deploy.server-extension.file")
      val timeout = Timeout(config.getDuration("xl-deploy.server-extension.timeout", TimeUnit.SECONDS), TimeUnit.SECONDS)
    }
  }
}

object XlPlatformSettings extends ExtensionId[XlPlatformSettings] with ExtensionIdProvider {
  override def lookup() = XlPlatformSettings

  override def createExtension(system: ExtendedActorSystem) = new XlPlatformSettings(system.settings.config)

  def apply(implicit context: ActorContext): XlPlatformSettings = apply(context.system)
}
