package com.xebialabs.xlplatform.ui

import akka.actor.{ExtensionIdProvider, ExtensionId, Extension, ExtendedActorSystem}
import com.typesafe.config.Config

class Settings(config: Config, extendedSystem: ExtendedActorSystem) extends Extension

object Settings extends ExtensionId[Settings] with ExtensionIdProvider {
  object XlDeploy {
    object UiExtension {
      def file(config: Config) = config.getString("xl-deploy.ui-extension.file")
    }
  }

  override def lookup() = Settings
  override def createExtension(system: ExtendedActorSystem) = new Settings(system.settings.config, system)
}
