package com.xebialabs.xlplatform.ui

import spray.json._

trait MenuJsonProtocol extends DefaultJsonProtocol {
  implicit val iMenuFormat: JsonFormat[IMenu] = lazyFormat(new RootJsonFormat[IMenu] {
    override def write(obj: IMenu): JsValue = obj match {
      case menu: Menu => menu.toJson
      case menuItem: MenuItem => menuItem.toJson
      case menuSeparator: MenuSeparator => menuSeparator.toJson
      case library: ExtensionLibrary => library.toJson
    }

    override def read(json: JsValue): IMenu = json match {
      case menu: JsObject if menu.fields.isDefinedAt("id") => menu.convertTo[Menu]
      case menuItem: JsObject if menuItem.fields.isDefinedAt("label") => menuItem.convertTo[MenuItem]
      case menuSeparator: JsObject if menuSeparator.fields.isDefinedAt("weight") => menuSeparator.convertTo[MenuSeparator]
      case library: JsObject if library.fields.isDefinedAt("library") => library.convertTo[ExtensionLibrary]
    }
  })
  implicit val menuItemFormat: JsonFormat[MenuItem] = lazyFormat(jsonFormat5(MenuItem))
  implicit val menuSeparatorFormat: RootJsonFormat[MenuSeparator] = jsonFormat1(MenuSeparator)
  implicit val menuFormat: JsonFormat[Menu] = lazyFormat(jsonFormat5(Menu))
  implicit val libraryFormat: RootJsonFormat[ExtensionLibrary] = jsonFormat1(ExtensionLibrary)

  implicit val menuListFormat = lazyFormat(new RootJsonFormat[Vector[IMenu]] {
    override def read(json: JsValue): Vector[IMenu] = json match {
      case JsArray(elems) => elems.map(_.convertTo[IMenu])
      case _ => throw new Exception(s"JSON value of type ${json.getClass.getName} cannot be turned into a List[Menu]")
    }

    override def write(obj: Vector[IMenu]): JsValue = JsArray(obj.map(_.toJson))
  })

  implicit val orderedMenuFormat: JsonFormat[OrderedMenu] = lazyFormat(new RootJsonFormat[OrderedMenu] {
    override def write(obj: OrderedMenu): JsValue = obj match {
      case menu: Menu => menu.toJson
      case menuItem: MenuItem => menuItem.toJson
      case menuSeparator: MenuSeparator => menuSeparator.toJson
    }

    override def read(json: JsValue): OrderedMenu = json match {
      case menu: JsObject if menu.fields.isDefinedAt("id") => menu.convertTo[Menu]
      case menuItem: JsObject if menuItem.fields.isDefinedAt("label") => menuItem.convertTo[MenuItem]
      case menuSeparator: JsObject => menuSeparator.convertTo[MenuSeparator]
    }
  })

}
