package com.xebialabs.xlplatform.ui

import scala.language.implicitConversions
import scala.xml.{NodeSeq, Text, Elem}
import spray.httpx.marshalling.Marshaller
import spray.http.MediaTypes._


trait MenuXmlProtocol {

  implicit def optStringToOptText(opt: Option[String]): Option[Text] = opt.map(Text(_))

  def menuItemToXml(m: MenuItem): Elem = <menu-item label={m.label} uri={m.uri} weight={m.weight.toString} path-suffix={m.pathSuffix}>{
    for ((k,v) <- m.properties) yield <property name={k} value={v} />
  }</menu-item>

  def menuSeparatorToXml(m: MenuSeparator): Elem = <menu-separator weight={m.weight.toString}/>

  def libraryToXml(l: ExtensionLibrary): Elem = <library name={l.library}/>

  val menuToXml: (Menu) => NodeSeq = (m: Menu) => <menu id={m.id} label={m.label} uri={m.uri} weight={m.weight.toString}>{
    m.items.map {
      case menu: Menu => menuToXml(menu)
      case menuItem: MenuItem => menuItemToXml(menuItem)
      case menuSeparator: MenuSeparator => menuSeparatorToXml(menuSeparator)
    }
    }</menu>

  val iMenuToXml : (IMenu) => NodeSeq = {
    case menu: Menu => menuToXml(menu)
    case menuItem: MenuItem => menuItemToXml(menuItem)
    case library: ExtensionLibrary => libraryToXml(library)
    case _ => throw new IllegalArgumentException("Only Menu, MenuItem or Library can be printed in the root element of XML file")
  }

  implicit val XmlMenuMarshaller = Marshaller.delegate[IMenu, NodeSeq](`text/xml`, `application/xml`)(iMenuToXml)

  implicit val XmlMenuItemListMarshaller = Marshaller.delegate[scala.collection.immutable.List[IMenu], NodeSeq](`text/xml`, `application/xml`)(hs =>
    <list>
      { for (h <- hs) yield iMenuToXml(h) }
    </list>

  )
}
