package com.xebialabs.xlplatform.ui

import akka.actor.{ExtensionIdProvider, ExtensionId, Extension, ExtendedActorSystem}
import com.typesafe.config.Config

class Settings(config: Config, extendedSystem: ExtendedActorSystem) extends Extension {

  object XlDeploy {
    object UiExtension {
      val file = config.getString("xl-deploy.ui-extension.file")
    }
  }
}

object Settings extends ExtensionId[Settings] with ExtensionIdProvider {
  override def lookup() = Settings
  override def createExtension(system: ExtendedActorSystem) = new Settings(system.settings.config, system)
}
