package com.xebialabs.xlplatform.ui

import akka.actor.{Actor, Props}
import akka.pattern._
import akka.util.Timeout
import com.xebialabs.xlplatform.endpoints.AuthenticatedData
import grizzled.slf4j.Logging
import spray.http.{HttpResponse, StatusCodes}
import spray.httpx.SprayJsonSupport
import spray.routing.HttpService

import scala.concurrent.duration._
import scala.language.postfixOps
import scala.util.{Failure, Success, Try}


trait MetadataExtensionRoute extends HttpService with SprayJsonSupport with MenuXmlProtocol with MenuJsonProtocol with Logging {

  case object GetMenus

  import scala.concurrent.ExecutionContext.Implicits.global

  implicit val timeout = Timeout(2 seconds)

  lazy val menuActor = actorRefFactory.actorOf(Props.apply(new Actor with Logging {

    override def receive: Receive = {
      case GetMenus =>
        sender ! Try(UiMenus.apply(Settings(context.system).XlDeploy.UiExtension.file))
    }

  }))


  val metadataRoute = (auth: AuthenticatedData) => pathPrefix("metadata") {
    (get|post) {
      onSuccess(menuActor ? GetMenus) {
        case Success(menus) =>
          logger.info(s"Found UI extensions: $menus")
          complete(menus.asInstanceOf[List[Menu]])
        case Failure(e: DuplicationException) =>
          logger.error(s"UI extensions could not be loaded", e)
          complete(HttpResponse(StatusCodes.InternalServerError, e.getMessage))
      }
    }
  }
}
