package com.xebialabs.xlplatform.ui

import scala.util.{Failure, Try, Success}
import akka.actor._

object UiMenuExtension extends ExtensionId[UiMenuExtension] with ExtensionIdProvider {
  override def createExtension(system: ExtendedActorSystem): UiMenuExtension = new UiMenuExtension(system)

  override def lookup(): ExtensionId[_ <: Extension] = UiMenuExtension
}

class UiMenuExtension(system: ActorSystem) extends Extension {

  val menus: List[Menu] = {
    Try(UiMenus.apply(Settings(system).XlDeploy.UiExtension.file)) match {
      case Success(m) => m
      case Failure(ex) =>
        system.shutdown()
        throw ex
    }
  }
}
