package com.xebialabs.xlplatform.ui

import spray.routing.HttpService
import akka.actor.{ActorLogging, Actor, Props}
import akka.pattern._
import akka.util.Timeout
import concurrent.duration._
import language.postfixOps
import spray.httpx.SprayJsonSupport
import com.xebialabs.xlplatform.endpoints.AuthenticatedData

trait MetadataExtensionRoute extends HttpService with SprayJsonSupport with MenuXmlProtocol with MenuJsonProtocol {
  case object GetMenus

  import scala.concurrent.ExecutionContext.Implicits.global

  implicit val timeout = Timeout(2 seconds)

  lazy val menuActor = actorRefFactory.actorOf(Props.apply(new Actor with ActorLogging {
    override def receive: Receive = {
      case GetMenus => val menus: List[Menu] = UiMenuExtension(context.system).menus
        log.info(s"Menus = $menus")
        sender() ! menus
    }
  }))

  val metadataRoute = (auth: AuthenticatedData) => pathPrefix("metadata") {
    (get|post) {
      complete((menuActor ? GetMenus).mapTo[List[Menu]])
    }
  }
}
