package com.xebialabs.xlplatform.test

import java.io.File
import java.util.UUID

import scala.reflect.io.Directory

trait TempFolderSugar {

  def createTmpFolder(name: String) = {
    val tmpDir = new File(System.getProperty("java.io.tmpdir"), name)
    if (!tmpDir.exists()) {
      tmpDir.mkdir()
      tmpDir
    } else {
      throw new IllegalStateException(s"Folder $name already exists")
    }
  }

  def createTmpFolder(): File = createTmpFolder(UUID.randomUUID().toString)

  def withTmpFolder[T](function: File => T) {
    val tmpFolder = createTmpFolder()
    try {
      function(tmpFolder)
    } finally {
      Directory(tmpFolder).deleteRecursively()
    }
  }
}
