package com.xebialabs.xlplatform.test

import java.net.{URLClassLoader, URL}

trait ClassLoaderSugar {

  def enhanceClassPath(resource: String)(x: => Unit) {
    val currentClassLoader: ClassLoader = Thread.currentThread.getContextClassLoader
    val myJarUrl: URL = currentClassLoader.getResource(resource)
    val enchancedClassloader: URLClassLoader = new URLClassLoader(Array[URL](myJarUrl), currentClassLoader)
    try {
      Thread.currentThread.setContextClassLoader(enchancedClassloader)
      x
    } finally {
      Thread.currentThread().setContextClassLoader(currentClassLoader)
    }
  }
}
