package com.xebialabs.xlplatform.support.report

import grizzled.slf4j.Logging
import org.apache.commons.io.FileUtils

import java.io.{File, IOException}
import java.nio.charset.StandardCharsets

object SupportPackageFileWriter extends Logging {
  private lazy val defaultExceptionMsg = "Exception occurred in writing to file"

  def writeToFile(fileName: String, data: String): Unit = {
    try {
      FileUtils.writeStringToFile(new File(fileName), data, StandardCharsets.UTF_8)
    } catch {
      case ex: IOException => logger.info(s"$defaultExceptionMsg, $fileName, error ${ex.getMessage}")
    }
  }
}
