package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import org.springframework.security.core.Authentication;

import java.util.List;

import static com.xebialabs.deployit.security.Permissions.getAuthentication;

public class PermissionHelper {
    public static boolean hasPermission(Permission permission) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission);
    }

    public static boolean hasPermission(Permission permission, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission, onConfigurationItem);
    }

    public static void applyPermission(final SearchParameters parameters, final Permission permission) {
        SecurityServiceLocator.getPermissionEnforcer().applyLoggedInUserPermission(parameters, permission);
    }

    public static List<Role> getCurrentRoles() {
        return SecurityServiceLocator.getPermissionEnforcer().getUserRoles(getAuthentication());
    }

    public static boolean isCurrentUserAdmin() {
        return SecurityServiceLocator.getPermissionEnforcer().isCurrentUserAdmin();
    }

    public static boolean isAdmin(Authentication authentication) {
        return SecurityServiceLocator.getPermissionEnforcer().isAdmin(authentication);
    }
}
