package com.xebialabs.deployit.security.authentication;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class RememberMeAuthenticationProvider implements AuthenticationProvider {
    @Override
    public Authentication authenticate(Authentication token) throws AuthenticationException {
        logger.debug("Checking whether [{}] was already logged in.", token.getPrincipal());
        final String username = token.getPrincipal().toString();
        final String password = token.getCredentials().toString();

        Authentication remembered = RememberMe.getRemembered(username, password);
        if (remembered != null) {
            logger.trace("User [{}] was remembered.", username);
            return remembered;
        }

        return null;
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class);
    }

    private static final Logger logger = LoggerFactory.getLogger(RememberMeAuthenticationProvider.class);
}
