package com.xebialabs.deployit.security.authentication;

import javax.naming.directory.SearchControls;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.NestedLdapAuthoritiesPopulator;

/**
 * Custom nested authorities populator based on {@link NestedLdapAuthoritiesPopulator} which uses pagination.
 * Use this poplulator only if pagination support is required.
 *
 * Issue was reported with spring-security (https://github.com/spring-projects/spring-security/issues/14741).
 * Once fixed, remove this class.
 */
public class CustomNestedLdapAuthoritiesPopulator extends NestedLdapAuthoritiesPopulator {

    private final CustomLdapTemplate customLdapTemplate;

    private final SearchControls searchControls = new SearchControls();

    /**
     * Constructor for group search scenarios. <tt>userRoleAttributes</tt> may still be
     * set as a property.
     *
     * @param contextSource   supplies the contexts used to search for user roles.
     * @param groupSearchBase if this is an empty string the search will be performed from
     *                        the root DN of the
     */
    public CustomNestedLdapAuthoritiesPopulator(final ContextSource contextSource, final String groupSearchBase) {
        this(contextSource, groupSearchBase, 100);
    }

    /**
     * Constructor for group search scenarios. <tt>userRoleAttributes</tt> may still be
     * set as a property.
     *
     * @param contextSource   supplies the contexts used to search for user roles.
     * @param groupSearchBase if this is an empty string the search will be performed from
     *                        the root DN of the context factory. If null, no search will be performed.
     * @param pageSize        pageSize with pagedResultsControl for search operations.
     */
    public CustomNestedLdapAuthoritiesPopulator(final ContextSource contextSource, final String groupSearchBase, final int pageSize) {
        super(contextSource, groupSearchBase);
        this.customLdapTemplate = new CustomLdapTemplate(contextSource, pageSize);
        getLdapTemplate().setSearchControls(getSearchControls());
    }

    @Override
    protected SpringSecurityLdapTemplate getLdapTemplate() {
        if (null == this.customLdapTemplate) {
            return super.getLdapTemplate();
        }
        return this.customLdapTemplate;
    }

    @Override
    public void setSearchSubtree(final boolean searchSubtree) {
        super.setSearchSubtree(searchSubtree);
        int searchScope = searchSubtree ? SearchControls.SUBTREE_SCOPE : SearchControls.ONELEVEL_SCOPE;
        this.searchControls.setSearchScope(searchScope);
    }

    /**
     * Sets the corresponding property on the underlying template, avoiding specific
     * issues with Active Directory.
     *
     * @see LdapTemplate#setIgnoreSizeLimitExceededException(boolean)
     */
    public void setIgnoreSizeLimitExceededException(boolean ignore) {
        getLdapTemplate().setIgnoreSizeLimitExceededException(ignore);
    }

    /**
     * Sets the corresponding property on the underlying template, avoiding specific
     * issues with Active Directory.
     *
     * @see LdapTemplate#setIgnoreNameNotFoundException(boolean)
     */
    public void setIgnoreNameNotFoundException(boolean ignore) {
        getLdapTemplate().setIgnoreNameNotFoundException(ignore);
    }

    private SearchControls getSearchControls() {
        return this.searchControls;
    }
}
