package com.xebialabs.deployit.security;

import com.xebialabs.deployit.engine.api.dto.Paging;

import java.util.List;
import java.util.Map;

public interface PermissionLister {

    Map<String, List<String>> listPermissions(Role role, Paging paging);

    Map<String, List<String>> listPermissions(List<Role> roles, Paging paging);

    Map<String, List<String>> listGlobalPermissions(List<Role> roles, Paging paging);

    default Map<String, List<String>> listPermissions(Role role) {
        return this.listPermissions(role, null);
    }

    default Map<String, List<String>> listPermissions(List<Role> roles) {
        return this.listPermissions(roles, null);
    }

    default Map<String, List<String>> listGlobalPermissions(List<Role> roles) {
        return this.listGlobalPermissions(roles, null);
    }
}
