package com.xebialabs.deployit.security.crowd;

import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.model.user.User;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY,
        getterVisibility = JsonAutoDetect.Visibility.NONE,
        isGetterVisibility = JsonAutoDetect.Visibility.NONE)
abstract public class CrowdUserDetailsMixin extends CrowdUserDetails {

    @JsonCreator
    public CrowdUserDetailsMixin(@JsonProperty("principal") User principal,
                                 @JsonProperty("authorities") Collection<GrantedAuthority> authorities) {
        super(principal, authorities);
    }
}

