package com.xebialabs.deployit.security.crowd

import com.fasterxml.jackson.annotation.{JsonAutoDetect, JsonCreator, JsonIgnoreProperties, JsonProperty, JsonTypeInfo}

@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE,
  isGetterVisibility = JsonAutoDetect.Visibility.NONE, creatorVisibility = JsonAutoDetect.Visibility.ANY)
@JsonCreator
case class WebAuthenticationDetailsMixin(@JsonProperty("remoteAddress")  remoteAddress : String,
                                         @JsonProperty("sessionId")  sessionId : String)
