package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.permission.Permission;

import java.util.List;
import java.util.Map;

import org.springframework.security.core.Authentication;

public interface PermissionChecker {
    boolean checkPermission(List<Permission> permissions, String onConfigurationItem, List<Role> allRoles);

    boolean checkPermission(List<Permission> permissions, String onConfigurationItem, List<Role> allRoles, final Authentication auth);

    Map<String, Boolean> checkPermission(List<Permission> permissions, List<String> onConfigurationItems, List<Role> allRoles);

    Map<String, Boolean> checkPermission(List<Permission> permissions, List<String> onConfigurationItems, List<Role> allRoles, final Authentication auth);
}
