package com.xebialabs.deployit.security;

import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.spi.exception.SuppressStackTrace;
import com.xebialabs.deployit.security.permission.Permission;

/**
 */
@SuppressWarnings("serial")
@HttpResponseCodeResult(statusCode = 403)
@SuppressStackTrace(suppressStackTrace = true)
public class PermissionDeniedException extends DeployitException {

    public PermissionDeniedException(final String message, final Exception cause) {
        super(cause, message);
    }

    public PermissionDeniedException() {
        super();
    }

    public PermissionDeniedException(final String message) {
        super(message);
    }

    public static PermissionDeniedException withMessage(final String message, final Exception cause) {
        return new PermissionDeniedException(message, cause);
    }
    public static PermissionDeniedException withMessage(final String message) {
        return new PermissionDeniedException(message);
    }

    public static PermissionDeniedException forNodeAndPrivilege(final String id, final String privilege) {
        final PermissionDeniedException deniedException = new PermissionDeniedException();
        deniedException.add("You do not have %s privilege on %s", privilege, id);
        return deniedException;
    }

    public static PermissionDeniedException forPermission(Permission permission, List<String> onConfigurationItems) {
        final PermissionDeniedException deniedException = new PermissionDeniedException();
        deniedException.add("You do not have %s permission on %s", permission, onConfigurationItems);
        return deniedException;
    }

    public static PermissionDeniedException forPermission(Permission permission, String onConfigurationItem) {
        final PermissionDeniedException deniedException = new PermissionDeniedException();
        if (onConfigurationItem == null) {
            deniedException.add("You do not have %s permission", permission);
        } else {
            deniedException.add("You do not have %s permission on %s", permission, onConfigurationItem);
        }
        return deniedException;
    }

    public static PermissionDeniedException forPermissions(List<Permission> permissions, String onConfigurationItem) {
        final PermissionDeniedException deniedException = new PermissionDeniedException();
        if (onConfigurationItem == null) {
            deniedException.add("You do not have any of the %s permissions", joinPermissions(permissions));
        } else {
            deniedException.add("You do not have any of the %s permissions on %s", joinPermissions(permissions), onConfigurationItem);
        }
        return deniedException;
    }

    private static String joinPermissions(List<Permission> permissions) {
        return permissions.stream().map(Permission::toString).collect(Collectors.joining(", "));
    }
}
