package com.xebialabs.deployit.security;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityTemplate {
    public static Authentication setCredentials(final String username, final String password) {
        return setAuthentication(new UsernamePasswordAuthenticationToken(username, password));
    }

    public static Authentication setAuthentication(final Authentication authentication) {
        final SecurityContext context = SecurityContextHolder.getContext();
        final Authentication origAuthentication = context.getAuthentication();
        context.setAuthentication(authentication);
        return origAuthentication;
    }

    public static void restoreAuthentication(final Authentication origAuthentication) {
        SecurityContextHolder.getContext().setAuthentication(origAuthentication);
    }

}
