package com.xebialabs.deployit.security.authentication;

        import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
        import com.atlassian.crowd.integration.springsecurity.RemoteCrowdAuthenticationProvider;
        import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
        import com.atlassian.crowd.service.client.CrowdClient;
        import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
        import org.springframework.security.core.Authentication;
        import org.springframework.security.core.AuthenticationException;

public class XLCrowdAuthenticationProvider extends RemoteCrowdAuthenticationProvider {
    public XLCrowdAuthenticationProvider(CrowdClient authenticationManager, CrowdHttpAuthenticator httpAuthenticator, CrowdUserDetailsService userDetailsService) {
        super(authenticationManager, httpAuthenticator, userDetailsService);
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (this.supports(authentication.getClass()) && authentication instanceof UsernamePasswordAuthenticationToken) {
            return this.authenticateUsernamePassword((UsernamePasswordAuthenticationToken) authentication);
        }
        return null;
    }
}