package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RolesPermissionsPair;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import static com.xebialabs.deployit.security.Permissions.getAuthentication;

public class ReadPermissionHandler extends PermissionHandler {

    public ReadPermissionHandler() {
        super(PlatformPermissions.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getUser(), Permission.getReadPermissions(), onConfigurationItem);
            } else if (viewAsData.getRoles() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getRoles(), Permission.getReadPermissions(), onConfigurationItem);
            }
        }
        return permissionEnforcer.hasLoggedInUserPermission(Permission.getReadPermissions(), onConfigurationItem);
    }

    private List<Role> getCurrentRoles(ViewAsData viewAsData) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                return permissionEnforcer.getUserRoles(viewAsData.getUser());
            } else if (viewAsData.getRoles() != null) {
                return viewAsData.getRoles();
            }
        }
        return permissionEnforcer.getUserRoles(getAuthentication());
    }

    @Override
    public RolesPermissionsPair getRolesPermissionsPair() {
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        return new RolesPermissionsPair(
                getCurrentRoles(viewAsData).stream().map(Role::getId).collect(Collectors.toList()),
                Permission.getReadPermissions().stream().map(Permission::getPermissionName).collect(Collectors.toList()));
    }

    @Override
    public void applyPermission(SearchParameters parameters) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null && (viewAsData.getUser() != null || viewAsData.getRoles() != null)) {
            permissionEnforcer.applyPermission(parameters, getCurrentRoles(viewAsData), Permission.getReadPermissions());
        }
        else {
            permissionEnforcer.applyLoggedInUserPermission(parameters, Permission.getReadPermissions());
        }
    }
}
