package com.xebialabs.deployit.security.permission;


import java.util.List;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.repository.SearchParameters;

public class PermissionHandler {

    private Permission permission;

    public PermissionHandler(Permission permission) {
        this.permission = permission;
    }

    public enum Level {
        GLOBAL,
        CI,
        BOTH
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean hasPermission(String onConfigurationItem) {
        if (Strings.isBlank(onConfigurationItem)) {
            return PermissionHelper.hasPermission(getPermission());
        }
        return PermissionHelper.hasPermission(getPermission()) || PermissionHelper.hasPermission(getPermission(), onConfigurationItem);
    }

    public void applyPermission(SearchParameters parameters) {
        PermissionHelper.applyPermission(parameters, getPermission());
    }

    public boolean isCurrentUserAdmin() {
        return PermissionHelper.isCurrentUserAdmin();
    }
}
