package com.xebialabs.deployit.security.permission;

import java.util.List;
import com.typesafe.config.ConfigException;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.SecurityServiceLocator;

public class ReadPermissionHandler extends PermissionHandler {

    public ReadPermissionHandler() {
        super(PlatformPermissions.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getUser(), Permission.getReadPermissions(), onConfigurationItem);
            } else if (viewAsData.getRoles() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getRoles(), Permission.getReadPermissions(), onConfigurationItem);
            }
        }
        return permissionEnforcer.hasLoggedInUserPermission(Permission.getReadPermissions(), onConfigurationItem);
    }

    @Override
    public void applyPermission(SearchParameters parameters) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                permissionEnforcer.applyPermission(parameters, viewAsData.getUser(), Permission.getReadPermissions());
            } else if (viewAsData.getRoles() != null) {
                permissionEnforcer.applyPermission(parameters, viewAsData.getRoles(), Permission.getReadPermissions());
            }
        } else {    
            permissionEnforcer.applyLoggedInUserPermission(parameters, Permission.getReadPermissions());
        }
    }
}
