package com.xebialabs.deployit.security.authentication.viewas;

import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
public class JackrabbitViewAsAuthenticationFinder implements ViewAsAuthenticationFinder {

    @Autowired
    private UserService userService;

    @Override
    public Authentication search(String username) {
        if (userService.listUsernames().contains(username)) {
            User user = userService.read(username);
            if (user.isAdmin()) {
                throw new IllegalArgumentException("Cannot view as admin.");
            }
            return new UsernamePasswordAuthenticationToken(username, null, new ArrayList<>());
        }
        return null;
    }
}
