/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import org.springframework.security.core.Authentication;

public class PermissionHelper {
    static boolean hasPermission(Permission permission) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission);
    }

    static boolean hasPermission(Permission permission, String onConfigurationItem) {
        return SecurityServiceLocator.getPermissionEnforcer().hasLoggedInUserPermission(permission, onConfigurationItem);
    }

    public static void applyPermission(SearchParameters parameters, Permission permission) {
        SecurityServiceLocator.getPermissionEnforcer().applyLoggedInUserPermission(parameters, permission);
    }

    public static boolean isCurrentUserAdmin() {
        return SecurityServiceLocator.getPermissionEnforcer().isCurrentUserAdmin();
    }

    public static boolean isAdmin(Authentication authentication) {
        return SecurityServiceLocator.getPermissionEnforcer().isAdmin(authentication);
    }
}

