package com.xebialabs.deployit.security.permission;

import com.typesafe.config.ConfigException;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.SecurityServiceLocator;

public class ReadPermissionHandler extends PermissionHandler {

    public ReadPermissionHandler() {
        super(PlatformPermissions.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getUser(), Permission.getReadPermissions(), onConfigurationItem);
            } else if (viewAsData.getRoles() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getRoles(), Permission.getReadPermissions(), onConfigurationItem);
            }
        }
        return permissionEnforcer.hasLoggedInUserPermission(Permission.getReadPermissions(), onConfigurationItem);
    }

}
