package com.xebialabs.deployit.security.permission;


import com.xebialabs.deployit.booter.local.utils.Strings;

public class PermissionHandler {

    private Permission permission;

    public PermissionHandler(Permission permission) {
        this.permission = permission;
    }

    public enum Level {
        GLOBAL,
        CI,
        BOTH
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean hasPermission(String onConfigurationItem) {
        if (Strings.isBlank(onConfigurationItem)) {
            return PermissionHelper.hasPermission(getPermission());
        }
        return PermissionHelper.hasPermission(getPermission()) || PermissionHelper.hasPermission(getPermission(), onConfigurationItem);
    }

    public boolean isCurrentUserAdmin() {
        return PermissionHelper.isCurrentUserAdmin();
    }
}
