package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class SecurityServiceLocator {

    private static final AtomicReference<PermissionEnforcer> permissionEnforcer = new AtomicReference<PermissionEnforcer>();

    private static final AtomicReference<ViewAsData> viewAsData = new AtomicReference<ViewAsData>();

    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceLocator.class);

    @Autowired
    public SecurityServiceLocator(PermissionEnforcer enforcer, ViewAsData viewAsData) {
        SecurityServiceLocator.permissionEnforcer.set(enforcer);
        SecurityServiceLocator.viewAsData.set(viewAsData);
    }

    public static PermissionEnforcer getPermissionEnforcer() {
        return SecurityServiceLocator.permissionEnforcer.get();
    }

    public static ViewAsData getViewAsData() {
        try {
            // Calling function to check if bean is accessible
            viewAsData.get().getUser();
            return viewAsData.get();
        } catch (BeanCreationException | IllegalStateException | NullPointerException e) {
            logger.debug("Session bean 'viewAsData' not accessible");
            // Ignore when the bean isn't accessible
            return null;
        }
    }
}
