/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.authentication.XlAuthenticationToken;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import org.springframework.security.core.Authentication;

public class ReadPermissionHandler
extends PermissionHandler {
    public ReadPermissionHandler() {
        super(PlatformPermissions.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        Authentication authentication = Permissions.getAuthentication();
        if (authentication instanceof XlAuthenticationToken) {
            XlAuthenticationToken xlAuthentication = (XlAuthenticationToken)authentication;
            if (xlAuthentication.getViewAsRoles() != null && !xlAuthentication.getViewAsRoles().isEmpty()) {
                return permissionEnforcer.hasPermission(xlAuthentication.getViewAsRoles(), Permission.getReadPermissions(), onConfigurationItem);
            }
            if (xlAuthentication.getViewAsUser() != null) {
                return permissionEnforcer.hasPermission(xlAuthentication.getViewAsUser(), Permission.getReadPermissions(), onConfigurationItem);
            }
        }
        return permissionEnforcer.hasLoggedInUserPermission(Permission.getReadPermissions(), onConfigurationItem);
    }
}

