/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.xebialabs.deployit.security.authentication.RememberMe;
import com.xebialabs.deployit.security.authentication.XlAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class RememberMeAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(RememberMeAuthenticationProvider.class);

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        logger.debug("Checking whether [{}] was already logged in.", token.getPrincipal());
        String username = token.getPrincipal().toString();
        String password = token.getCredentials().toString();
        Authentication remembered = RememberMe.getRemembered(username, password);
        if (remembered != null) {
            logger.trace("User [{}] was remembered.", (Object)username);
            return remembered;
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(XlAuthenticationToken.class);
    }
}

