package com.xebialabs.deployit.security.authentication.viewas;

import com.xebialabs.deployit.security.authentication.XlAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.CommunicationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class UserDetailsViewAsAuthenticationFinder implements ViewAsAuthenticationFinder {

    // TODO Find a way of preventing the instanciation of the component if there is no UserDetailsService injected.
    @Autowired(required=false)
    private UserDetailsService userDetailsService;

    private static final Logger logger = LoggerFactory.getLogger(UserDetailsViewAsAuthenticationFinder.class);

    public UserDetailsViewAsAuthenticationFinder() {
    }

    public UserDetailsViewAsAuthenticationFinder(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Override
    public Authentication search(String username) {
        try {
            if (userDetailsService != null) {
                UserDetails userDetails = userDetailsService.loadUserByUsername(username);
                return new XlAuthenticationToken(username, null, userDetails.getAuthorities());
            } else {
                return null;
            }
        } catch (UsernameNotFoundException e) {
            logger.debug("Username not found: " + username);
            return null;
        } catch (CommunicationException e) {
            logger.debug(e.toString());
            return null;
        } catch (Exception e) {
            logger.debug(e.toString());
            return null;
        }
    }

}
