package com.xebialabs.deployit.security.authentication;

import java.util.Collection;
import java.util.List;

import com.xebialabs.deployit.security.Role;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class XlAuthenticationToken extends UsernamePasswordAuthenticationToken {

    private List<Role> viewAsRoles;
    private Authentication viewAsUser;

    public XlAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public XlAuthenticationToken(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        super(username, password, authorities);
    }

    public List<Role> getViewAsRoles() {
        return viewAsRoles;
    }

    public void setViewAsRoles(List<Role> viewAsRoles) {
        this.viewAsRoles = viewAsRoles;
    }

    public Authentication getViewAsUser() {
        return viewAsUser;
    }

    public void setViewAsUser(final Authentication viewAsUser) {
        this.viewAsUser = viewAsUser;
    }
}
