package com.xebialabs.deployit.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

import com.xebialabs.deployit.security.permission.PlatformPermissions;

public class LoginPermissionVoter implements AccessDecisionVoter<Object> {

    private Set<String> whitelistUrls = new HashSet<>();

    @Override
    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (object instanceof FilterInvocation) {
            final String requestURI = ((FilterInvocation) object).getRequest().getRequestURI();
            if (whitelistUrls.contains(requestURI)) {
                logger.debug("Endpoint [{}] is whitelisted", requestURI);
                return ACCESS_GRANTED;
            }
        }

        logger.debug("Checking authorization for [{}]", authentication.getName());
        if (SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, PlatformPermissions.LOGIN)) {
            logger.debug("User [{}] is authorized for login", authentication.getName());
            return ACCESS_GRANTED;
        }
        logger.error("User [{}] is not allowed to login to XL Deploy.", authentication.getName());
        return ACCESS_DENIED;
    }

    public void setWhitelistUrls(Set<String> whitelistUrls) {
        this.whitelistUrls = whitelistUrls;
    }


    private static final Logger logger = LoggerFactory.getLogger(LoginPermissionVoter.class);
}
