/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class PermissionEnforcer {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    private JcrTemplate jcrTemplate;
    private final RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(PermissionEnforcer.class);

    @Autowired
    public PermissionEnforcer(JcrTemplate jcrTemplate, RoleService roleService) {
        this.jcrTemplate = jcrTemplate;
        this.roleService = roleService;
    }

    public boolean hasPermission(Authentication authentication, Permission ... permissions) {
        return this.hasPermission(authentication, Lists.newArrayList((Object[])permissions), "");
    }

    public boolean hasLoggedInUserPermission(Permission ... permissions) {
        Authentication authentication = Permissions.getAuthentication();
        return this.hasPermission(authentication, Lists.newArrayList((Object[])permissions), "");
    }

    public boolean hasLoggedInUserPermission(Permission permission, String onConfigurationItem) {
        return this.hasLoggedInUserPermission(Lists.newArrayList((Object[])new Permission[]{permission}), onConfigurationItem);
    }

    public boolean hasLoggedInUserPermission(List<Permission> permissions, String onConfigurationItem) {
        return this.hasPermission(Permissions.getAuthentication(), permissions, onConfigurationItem);
    }

    private boolean hasPermission(Authentication auth, List<Permission> permissions, String onConfigurationItem) {
        List allRoles;
        Collection<String> allPrincipals = Permissions.authenticationToPrincipals(auth);
        return this.isAdmin(allPrincipals, allRoles = this.roleService.getRolesFor(auth)) || this.checkPermission(permissions, onConfigurationItem, (List<Role>)allRoles);
    }

    private boolean checkPermission(final List<Permission> permissions, final String onConfigurationItem, final List<Role> allRoles) {
        return (Boolean)this.jcrTemplate.execute((JcrCallback)new JcrCallback<Boolean>(){

            public Boolean doInJcr(Session session) throws RepositoryException {
                if (Strings.nullToEmpty((String)onConfigurationItem).isEmpty()) {
                    return PermissionEnforcer.this.checkGlobalPermission(session, permissions, allRoles);
                }
                return PermissionEnforcer.this.checkCiPermission(session, permissions, onConfigurationItem, allRoles);
            }
        });
    }

    private boolean checkGlobalPermission(Session session, List<Permission> permissions, List<Role> allRoles) throws RepositoryException {
        Node node = session.getNode("/$configuration/security");
        Optional<Boolean> o = this.checkPermission(node, permissions, allRoles);
        if (o.isPresent()) {
            return (Boolean)o.get();
        }
        return false;
    }

    private boolean checkCiPermission(Session session, List<Permission> permissions, String onConfigurationItem, List<Role> allRoles) throws RepositoryException {
        List<String> nodes = this.nodesToInspect(onConfigurationItem);
        for (String nodeId : nodes) {
            Optional<Boolean> o;
            if (!session.nodeExists(nodeId) || !(o = this.checkCiPermission(session.getNode(nodeId), permissions, allRoles)).isPresent()) continue;
            return (Boolean)o.get();
        }
        return false;
    }

    private Optional<Boolean> checkCiPermission(Node node, List<Permission> permissions, List<Role> allRoles) throws RepositoryException {
        if (!Permissions.isSecurable(node)) {
            return Optional.absent();
        }
        return this.checkPermission(node, permissions, allRoles);
    }

    private Optional<Boolean> checkPermission(Node node, List<Permission> allPermissions, List<Role> allRoles) throws RepositoryException {
        logger.debug("Trying to read permissions from [{}]", (Object)node.getPath());
        Map<String, String> permissions = Permissions.readPermissionMap(node);
        if (permissions.isEmpty()) {
            logger.debug("[{}] has no permissions set, checking up the tree.", (Object)node.getPath());
            return Optional.absent();
        }
        logger.debug("[{}] has permissions enabled, which are: [{}]", (Object)node.getPath(), permissions);
        for (Permission permission : allPermissions) {
            Iterable<Integer> permittedRoles;
            if (!permissions.containsKey(permission.getPermissionName()) || !Iterables.any(permittedRoles = Permissions.splitRoles(permissions.get(permission.getPermissionName())), (Predicate)Predicates.in((Collection)Lists.newArrayList(Permissions.rolesToIds(allRoles))))) continue;
            return Optional.of((Object)true);
        }
        return Optional.of((Object)false);
    }

    private List<String> nodesToInspect(String onConfigurationItem) {
        return Lists.newArrayList((Iterable)Lists.transform(Permissions.getFullTreeAsSeparateNodesInChildToRootOrder(onConfigurationItem), (Function)new Function<String, String>(){

            public String apply(String input) {
                return JcrPathHelper.getAbsolutePathFromId((String)input);
            }
        }));
    }

    boolean isAdmin(Collection<String> allPrincipals, List<Role> allRoles) {
        Boolean isAdmin = allPrincipals.contains(ROLE_ADMIN) || this.checkPermission(Lists.newArrayList((Object[])new Permission[]{PlatformPermissions.ADMIN}), "", allRoles);
        logger.trace("Admin privileges [{}] granted to {}", (Object)(isAdmin != false ? "are" : "are not"), allPrincipals);
        return isAdmin;
    }

    public boolean isCurrentUserAdmin() {
        return this.isAdmin(Permissions.getAuthentication());
    }

    public boolean isAdmin(Authentication auth) {
        Collection<String> principals = Permissions.authenticationToPrincipals(auth);
        List allRoles = this.roleService.getRolesFor(auth);
        return this.isAdmin(principals, allRoles);
    }
}

