package com.xebialabs.deployit.security;

import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;

import static com.google.common.collect.Lists.newArrayList;

public class AdditionalAuthoritiesMapper implements GrantedAuthoritiesMapper {

    private List<String> additionalAuthorities = newArrayList();

    @Override
    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        List<GrantedAuthority> auths = newArrayList(authorities);
        for (String additionalAuthority : additionalAuthorities) {
            auths.add(new SimpleGrantedAuthority(additionalAuthority));
        }
        return auths;
    }

    public List<String> getAdditionalAuthorities() {
        return additionalAuthorities;
    }

    public void setAdditionalAuthorities(List<String> additionalAuthorities) {
        this.additionalAuthorities = additionalAuthorities;
    }
}
