/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
implements RoleService {
    private static final AtomicInteger groupNumber = new AtomicInteger(-1);
    private JcrTemplate jcrTemplate;
    private static final Logger logger = LoggerFactory.getLogger(RoleServiceImpl.class);

    @Autowired
    public RoleServiceImpl(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public List<Role> getRoles() {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<Role>>(){

            public List<Role> doInJcr(Session session) throws RepositoryException {
                return RoleServiceImpl.this.readRoles(session);
            }
        });
    }

    public List<Role> readRoleAssignments() {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<Role>>(){

            public List<Role> doInJcr(Session session) throws RepositoryException {
                return RoleServiceImpl.this.readRoleAssignments(session);
            }
        });
    }

    public void writeRoleAssignments(final List<Role> roles) {
        this.jcrTemplate.execute((JcrCallback)new JcrCallback<Object>(){

            public Object doInJcr(Session session) throws RepositoryException {
                RoleServiceImpl.this.writeRoles(session, roles);
                RoleServiceImpl.this.writeRoleAssignments(session, roles);
                session.save();
                return null;
            }
        });
    }

    public Role getRoleForRoleName(String roleName) {
        List<Role> roles = this.getRoles();
        for (Role role : roles) {
            if (!role.getName().equals(roleName)) continue;
            return role;
        }
        throw new NotFoundException("Could not find the role [%s]", new Object[]{roleName});
    }

    public List<Role> getRolesFor(Authentication auth) {
        Collection<String> principals = Permissions.authenticationToPrincipals(auth);
        return this.getRolesFor(principals);
    }

    public List<Role> getRolesFor(String principal) {
        return this.getRolesFor(Lists.newArrayList((Object[])new String[]{principal}));
    }

    private List<Role> readRoles(Session session) throws RepositoryException {
        Node node = session.getNode("/$configuration/roles");
        final ArrayList roles = Lists.newArrayList();
        JcrUtils.forEachNonJcrProperty((Node)node, (JcrUtils.Callback)new JcrUtils.Callback<Property>(){

            public void apply(Property input) throws RepositoryException {
                roles.add(new Role(Integer.valueOf(input.getName()), input.getString()));
            }
        });
        return roles;
    }

    private List<Role> readRoleAssignments(Session session) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        List<Role> roles = this.getRoles();
        final ImmutableMap<Integer, Role> lookup = Permissions.buildLookup(roles);
        JcrUtils.forEachNonJcrProperty((Node)node, (JcrUtils.Callback)new JcrUtils.Callback<Property>(){

            public void apply(Property input) throws RepositoryException {
                String principal = input.getName();
                Iterable<Integer> roles = Permissions.splitRoles(input.getString());
                for (Integer role : roles) {
                    ((Role)lookup.get(role)).getPrincipalsAssigned().add(principal);
                }
            }
        });
        return roles;
    }

    private void writeRoles(Session session, List<Role> roles) throws RepositoryException {
        Node node = session.getNode("/$configuration/roles");
        if (groupNumber.get() == -1) {
            groupNumber.compareAndSet(-1, this.readMaxRole(node) + 1);
        }
        JcrUtils.clearProperties((Node)node);
        for (Role role : roles) {
            if (role.getId() == null || role.getId() == -1) {
                role.setId(Integer.valueOf(groupNumber.getAndIncrement()));
            }
            node.setProperty(role.getId().toString(), role.getName());
        }
    }

    private int readMaxRole(Node node) throws RepositoryException {
        final int[] i = new int[]{-1};
        JcrUtils.forEachNonJcrProperty((Node)node, (JcrUtils.Callback)new JcrUtils.Callback<Property>(){

            public void apply(Property input) throws RepositoryException {
                int j = Integer.valueOf(input.getName());
                if (j > i[0]) {
                    i[0] = j;
                }
            }
        });
        return i[0];
    }

    private List<Role> getRolesFor(final Collection<String> principals) {
        return (List)this.jcrTemplate.execute((JcrCallback)new JcrCallback<List<Role>>(){

            public List<Role> doInJcr(Session session) throws RepositoryException {
                return RoleServiceImpl.this.principalsToRoles(session, principals);
            }
        });
    }

    private List<Role> principalsToRoles(Session session, Collection<String> principals) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        final ImmutableMap<Integer, Role> lookup = Permissions.buildLookup(this.getRoles());
        Function<Integer, Role> roleIdToRole = new Function<Integer, Role>(){

            public Role apply(Integer input) {
                return (Role)lookup.get((Object)input);
            }
        };
        ArrayList roles = Lists.newArrayList();
        for (String principal : principals) {
            if (!node.hasProperty(principal = JcrUtils.escapeIllegalJcrChars((String)principal))) continue;
            Property property = node.getProperty(principal);
            roles.addAll(Lists.newArrayList((Iterable)Iterables.transform(Permissions.splitRoles(property.getString()), (Function)roleIdToRole)));
        }
        logger.trace("Found roles {} for principals {}", (Object)roles, principals);
        return roles;
    }

    private void writeRoleAssignments(Session session, List<Role> map) throws RepositoryException {
        Node node = session.getNode("/$configuration/roleAssignments");
        JcrUtils.clearProperties((Node)node);
        ListMultimap<String, Role> principalRole = this.buildMap(map);
        for (String principal : principalRole.keySet()) {
            node.setProperty(JcrUtils.escapeIllegalJcrChars((String)principal), Permissions.joinRoles(Iterables.transform((Iterable)principalRole.get((Object)principal), (Function)new Function<Role, Integer>(){

                public Integer apply(Role input) {
                    return input.getId();
                }
            })));
        }
    }

    private ListMultimap<String, Role> buildMap(List<Role> map) {
        ArrayListMultimap principalToRoles = ArrayListMultimap.create();
        for (Role role : map) {
            for (String principal : role.getPrincipalsAssigned()) {
                principalToRoles.put((Object)principal, (Object)role);
            }
        }
        return principalToRoles;
    }
}

