package com.xebialabs.deployit.security.crowd

import java.util.regex.Pattern

import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility
import com.fasterxml.jackson.annotation.{JsonTypeInfo, PropertyAccessor}
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator
import com.fasterxml.jackson.databind.{DeserializationFeature, MapperFeature, ObjectMapper, SerializationFeature}
import com.xebialabs.deployit.security.SpringSessionConverterFactory
import org.springframework.security.jackson2.SecurityJackson2Modules

class CrowdSpringSessionConverterFactory extends SpringSessionConverterFactory {
  private def buildMapper(classLoader: ClassLoader): ObjectMapper = {
    val mapper = new ObjectMapper

    mapper.registerModules(SecurityJackson2Modules.getModules(classLoader))
    mapper.setVisibility(PropertyAccessor.FIELD, Visibility.ANY)
    mapper.disable(MapperFeature.AUTO_DETECT_GETTERS)
    mapper.enable(SerializationFeature.CLOSE_CLOSEABLE)

    val typeValidator: BasicPolymorphicTypeValidator =
      BasicPolymorphicTypeValidator.builder.allowIfBaseType(Pattern.compile(".*")).build
    mapper.addMixIn(classOf[CrowdUserDetails], classOf[CrowdUserDetailsMixin])
    mapper.activateDefaultTyping(typeValidator, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY)
    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
  }

  def buildSerializer(classLoader: ClassLoader) = new CrowdSerializingConverter(buildMapper(classLoader))

  def buildDeserializer(classLoader: ClassLoader) = new CrowdDeserializingConverter(buildMapper(classLoader), classLoader)
}
